import openmatrix as omx
import openpyxl
import numpy as np
import csv

def eliminadoppi(lista):
    for i in lista:
        if lista.count(i)>1:
            lista.remove(i)
            eliminadoppi(lista)
    return lista

#Apertura del file OMX di input
OMXfileI = omx.open_file('IMQ2013_zonecampionarie.omx')
print("File OMX di riferimento: ",OMXfileI.filename,'\n')
#Apertura del file OMX di output
OMXfileO = omx.open_file('IMQ2013_aggregazione.omx','w')

#Caricamento delle informazioni sulla mappatura (per conversione cod. alfanumerico - cod. numerico)
excel_document = openpyxl.load_workbook('ZoneCampionarie2013.xlsx') 
nsheet = excel_document.sheetnames  
sheet = excel_document[nsheet[0]] 
zoneA = list()   
zoneN = np.zeros(209)
for j in range(0,209):
    zoneA.append(sheet.cell(row=j+2,column=2).value)
    zoneN[j] = sheet.cell(row=j+2,column=1).value    

#Ottenimento dei dati di input
sel = int(input("Inserire criterio di aggregazione (1-per province, 2-per macro-aree): "))

#Apertura del file contenente l'elenco delle zone e il criterio di selezione
INfile = open('AGGREGAZIONE.csv','r')
reader = csv.reader(INfile, delimiter=',')
zoneORD = list()
CRIT = list()
criterio = list()
for row in reader:
    zoneORD.append(row[0])
    CRIT.append(row[sel])
    criterio.append(row[sel])
del zoneORD[0]
zoneORD.append("Esterno")
del CRIT[0]
CRIT.append("EXT")
del criterio[0]
criterio.append("EXT")
criterio = eliminadoppi(criterio)
dim = len(criterio)

#Estrazione delle matrici
for pop in ['TO','PIE']:
    for mez in ['Pr','Pu']:
        for per in ['IG','OP']:
            for sco in ['sr','t']:
                if not (sco=='sr' and per=='OP'):
                    NEWmatrOD = np.zeros((dim,dim))
                    for i in range(0,209):
                        indexO = zoneORD.index(zoneA[i])
                        indO = criterio.index(CRIT[indexO])                                  
                        for j in  range(0,209):
                            indexD = zoneORD.index(zoneA[j])
                            indD = criterio.index(CRIT[indexD])
                            NEWmatrOD[indO][indD] = NEWmatrOD[indO][indD]+OMXfileI['Res'+pop+'m'+mez+per+sco][i][j]
                    OMXfileO['Res'+pop+'m'+mez+per+sco] = NEWmatrOD
                    #Scrittura dei metadati complementari
                    OMXfileO['Res'+pop+'m'+mez+per+sco].attrs.Indagine = 'IMQ 2013'
                    if pop=='TO':
                        OMXfileO['Res'+pop+'m'+mez+per+sco].attrs.Popolazione = 'Provincia di Torino'
                        OMXfileO['Res'+pop+'m'+mez+per+sco].attrs.NumCampione = 32460
                    else:
                        OMXfileO['Res'+pop+'m'+mez+per+sco].attrs.Popolazione = 'Regione Piemonte'
                        OMXfileO['Res'+pop+'m'+mez+per+sco].attrs.NumCampione = 52119
                    if mez=='Pr':
                        OMXfileO['Res'+pop+'m'+mez+per+sco].attrs.Modo = 'Privato'
                    else:
                        OMXfileO['Res'+pop+'m'+mez+per+sco].attrs.Modo = 'Pubblico'
                    if per=='IG':
                        OMXfileO['Res'+pop+'m'+mez+per+sco].attrs.Periodo = 'Intera giornata'
                    else:
                        OMXfileO['Res'+pop+'m'+mez+per+sco].attrs.Periodo = 'Ora di punta (arrivo 07:43-08:42)'
                    if sco=='sr':
                        OMXfileO['Res'+pop+'m'+mez+per+sco].attrs.Scopo = 'Tutti escluso ritorno'
                    else:
                        OMXfileO['Res'+pop+'m'+mez+per+sco].attrs.Scopo = 'Tutti'     

#Associazione di un file .txt contenente la mappatura
fileMAP = open("mappatura_AGGREGAZIONE.txt","w")
i=1
for element in criterio:
    fileMAP.write((str(i)+';'+element)); fileMAP.write('\n')
    i = i+1
print("\nFILE OMX CREATO:  IMQ2013_aggregazione.omx")
print("FILE TXT CREATO:  mappatura_AGGREGAZIONE.txt")

#Chiusura dei file aperti
OMXfileI.close()
OMXfileO.close()
INfile.close()
fileMAP.close()







